tell application "iTunes.app"

	set ThePrefix to "%@"
	set TheResultsFile to (path to home folder from user domain as text) & "%@"
	set TheProtectedPrefix to "%@"
	set TheImporter to "%@"
	set ThePlaylist to "%@"

	set LF to ASCII character 10
	set quoteMark to "\""
	set trackCount to 0
	
		-- If needed make a playlist to hold them all
		set TheConvertedItemsPlaylistName to TheImporter & " From " & ThePrefix
		set DidFindTheConvertedItemsPlaylist to 0
		repeat with i from 1 to the count of playlists
			set TheSource to playlist i
			if name of TheSource begins with TheConvertedItemsPlaylistName then
				set DidFindTheConvertedItemsPlaylist to 1
				set TheConvertedItemsPlaylist to TheSource
				exit repeat
			end if
		end repeat
		
		if DidFindTheConvertedItemsPlaylist is equal to 0 then
			set TheConvertedItemsPlaylist to (make new playlist with properties {name:TheConvertedItemsPlaylistName})
		end if
	
	-- Delete the iTunes Converter playlist if it exists
	repeat with i from 1 to the count of playlists
		set TheSource to playlist i
		if name of TheSource begins with ThePrefix then
			delete TheSource
			exit repeat
		end if
	end repeat
	
	-- Create the new iTunes Converter playlist
	set TheNewPlaylist to (make new playlist with properties {name:ThePrefix})
	
	set all_tracks to every track of TheConvertedItemsPlaylist 
	if ThePlaylist is equal to "Library"
	     set all_protected_tracks to every track of library playlist 1 whose kind contains TheProtectedPrefix
	else
	     set all_protected_tracks to every track of user playlist ThePlaylist whose kind contains TheProtectedPrefix
	end if
	
	repeat with protected_track in all_protected_tracks
		
		set protected_track_class to (get class of protected_track)
		
		if (protected_track_class is file track) then
			set protected_track_time to (get duration of protected_track)
			set protected_track_location to (get location of protected_track)
			if protected_track_location is missing value then
				set protected_track_time to 6000
				set protected_track_location to ""
				set protected_track_ext to ""
			else
				set protected_track_ext to name extension of (info for protected_track_location)
			end if
		else
			set protected_track_time to 6000
			set protected_track_location to ""
			set protected_track_ext to ""
		end if
		
		set need_this_track to 0
		
		if protected_track_time < 2700 and (protected_track_ext is "m4p" or protected_track_ext is "m4b") then
			set need_this_track to 1
			set protected_track_name to (get name of protected_track)
			set protected_track_artist to (get artist of protected_track)
			set protected_track_grouping to (get grouping of protected_track)
			set protected_track_kind to (get kind of protected_track)
	
			repeat with a_track in all_tracks
		
				set a_track_name to (get name of a_track)
				set a_track_artist to (get artist of a_track)
				set a_track_grouping to (get grouping of a_track)
			
				if protected_track_name is equal to a_track_name and protected_track_artist is equal to a_track_artist and protected_track_grouping is equal to a_track_grouping then
					set need_this_track to 0
					exit repeat
				end if

				if protected_track_kind is "Protected MPEG-4 video file" then
					set need_this_track to 0
					exit repeat
				end if
	
			end repeat
		
		end if
		
		if need_this_track is equal to 1 then
			duplicate protected_track to playlist ThePrefix
			set trackCount to trackCount + 1	
		end if
		
		
	end repeat


	try
        	set results_fd to open for access file TheResultsFile with write permission
                on error
                        close access file TheResultsFile
                        set results_fd to open for access file TheResultsFile with write permission
                end try

                set eof of results_fd to 0
		write "<?xml version=" & quoteMark & "1.0" & quoteMark & " encoding=" & quoteMark & "UTF-8" & quoteMark & "?>" & LF to results_fd
		write "<!DOCTYPE plist PUBLIC " & quoteMark & "-//Apple Computer//DTD PLIST 1.0//EN" & quoteMark & " " & quoteMark & "http://www.apple.com/DTDs/PropertyList-1.0.dtd" & quoteMark & ">" & LF to results_fd
		write "<plist version=" & quoteMark & "1.0" & quoteMark & ">" & LF to results_fd
		write "<dict>" & LF to results_fd
		write tab & "<key>trackstoconvert</key>" & LF to results_fd
		write tab & "<integer>" & (get trackCount as string) & "</integer>" & LF to results_fd
		write "</dict>" & LF to results_fd
		write "</plist>" & LF to results_fd
		close access results_fd	

end tell

